#ifndef CRFEPURSTATICREFLECTEDPOWERMEASUREMENT_H
#define CRFEPURSTATICREFLECTEDPOWERMEASUREMENT_H

#include "../../ui/TabWidget.h"
#include "../../ui/ConfigDialog.h"
#include <ui_CRfePurStaticReflectedPowerMeasurement.h>

class QwtDial;
class DynamicNeedle;

class QrfeReaderInterface;
class QrfeRfePurReader;

class CRfePurStaticReflectedPowerMeasurement : public ReaderTabWidget, ConfigDialog
{
    Q_OBJECT

public:
    CRfePurStaticReflectedPowerMeasurement(QTextEdit* infoEdit, QWidget* parent);
    ~CRfePurStaticReflectedPowerMeasurement();

	virtual bool init(QrfeReaderInterface* reader);
	virtual void deinit();
	virtual void activated();

	virtual bool hasExecutionCount();

public slots:
	void startStopRfpMeasurement();

	void setAttenuationLabel ( int value );

private slots:
	void measureReflectedPower();

private:
	void reloadLicenseData();

    void loadValuesFromCache();
    void saveValuesToCache();

private:
    QrfeRfePurReader* 		m_reader;

    bool				m_rfpMeasurementActive;
    QwtDial*			m_rfpMeasurementDial;
	DynamicNeedle* 		m_rfpMeasurementNeedle;

    Ui::CRfePurStaticReflectedPowerMeasurementClass ui;
};

#endif // CRFEPURSTATICREFLECTEDPOWERMEASUREMENT_H
